

--print table
function printTab(tab)
  for i,v in pairs(tab) do
    if type(v) == "table" then
      print("table",i,"{")
      printTab(v)
      print("}")
    else
     print(v)
    end
  end
end

-- change table to enum type
function CreateEnumTable(tbl, index)
    local enumTable = {}
    local enumIndex = index or -1
    for i, v in ipairs(tbl) do
        enumTable[v] = enumIndex + i
    end
    return enumTable
end


function removeAll(tempTable)
    if tempTable~=nil and type(tempTable) == "table" then
        while true do
            local k =next(tempTable)
            if not k then break end
            tempTable[k] = nil
        end
    end
end

List = {}
function List.new()
	return {first = 0, last = -1}
end

function List.pushfirst(list, value)
	local first = list.first - 1
	list.first = first
	list[first] = value
end

function List.pushlast(list, value)
	local last = list.last + 1
	list.last = last
	list[last] = value
end

function List.popfirst(list)
	local first = list.first
	if first > list.last then return nil end
	local value = list[first]
	list[first] = nil
	list.first = first + 1
	return value
end

function List.poplast(list)
	local last = list.last
	if list.first > last then return nil end
	local value = list[last]
	list[last] = nil
	list.last = last - 1
	return value	
end

function List.removeAll(list)
    removeAll(list)
    list.first = 0
    list.last = -1
end

function List.getSize(list)
    return list.last - list.first + 1
end

function List.getFirst(list)
    local value = nil
    if list.first <= list.last then
        value = list[list.first]
    end
    
    return value
end


function List.getLast(list)
    local value = nil
    if list.last >= list.first then
        value = list[list.last]
    end
    
    return value
end

function List.remove(list, index)
    if index < list.first or index > list.last then return false end
    
    while index <= list.last do
        list[index] = nil
        list[index] = list[index+1]
        index = index + 1
    end
    
    list.last = list.last -1
    return true
end

function List.removeObj(list, obj)
    if obj == nil or List.getSize(list) == 0 then return false end
    
    for index=list.first, list.last do
    	if list[index] == obj then
    		List.remove(list,index)
            return index
    	end
    end
    return false    
end

function copyTable(t1, t2)
    if t1 == nil or t2==nil then return end

    for key, var in pairs(t1) do
        t2[key] = var
    end
end

function buttonPressed( event )
    -- body
    local target=event.target
    if target then
        target:setScale(1.2)
    end 
end

function buttonRelease( event )
    -- body
    local target=event.target
    if target then
        target:setScale(1.0)
    end 
end

function tableNums(t)
    local count = 0
    local t = checktable(t)
    for k, v in pairs( t ) do
        count = count + 1
    end
    return count
end

--table迭代器 从大到小key 排序
function pairsByWithMaxKeys(t)  
    local a = {}  
    for n in pairs(t) do  
        a[#a+1] = n  
    end  
    table.sort(a)  
    local i = #a
    print("i=====",i)
    return function()  
        
        local key=a[i]
        local value=t[a[i]]
        i = i - 1  
        return key, value
    end  
end 


--table迭代器 从小到大key 排序
function pairsByKeys(t)      
    local a = {}      
    for n in pairs(t) do          
        a[#a+1] = n      
    end      
    table.sort(a)      
    local i = 0      
    return function()          
    i = i + 1          
    return a[i], t[a[i]]      
    end  
end

--方块最近的col
function LessRecentlyCol(r,c)
    local rGridTable=RoadGridTable[r]
    local count=tableNums(rGridTable)
    if count>0 then
        --todo
        for col, blockInfo in pairsByWithMaxKeys(rGridTable) do
            if col<c then
                --todo
                return col
            end
        end    
    end

    return nil
end    


-- --最大方块最近的col
-- function LessContinuousRecentlyCol(r,c)
--     local rGridTable=RoadGridTable[r]
--     local count=tableNums(rGridTable)
--     if count>0 then
--         --todo
--         for col, blockInfo in pairsByWithMaxKeys(rGridTable) do
--             if col<c then
--                 --todo
--                 --是否竖直方向连续
--                 if c-col=1 then
--                     c=col
--                 else
--                     return col    
--                 end
                
--             end
--         end    
--     end

--     return nil
-- end    


--爆炸方块最近的col
-- function boomLessRecentlyCol(r,c)
--     local rGridTable=RoadGridTable[r]
--     local count=tableNums(rGridTable)
--     if count>0 then
--         --todo
--         for col, blockInfo in pairsByWithMaxKeys(rGridTable) do
--             if col<c then
--                 --todo
--                 return col
--             end
--         end    
--     end

--     return nil
-- end    



function copyAllTable(st)
    local tab = {}
    for k, v in pairs(st or {}) do
        if type(v) ~= "table" then
            tab[k] = v
        else
            tab[k] = copyAllTable(v)
        end
    end
    return tab
end

-- getpostable
function getPosTable(obj)
    if obj==nil then
        return {x= 0,y=0} 
    end
    local posX,posY = obj:getPosition()
    return {x= posX,y=posY} 
end

function getContenSize(obj)
    if obj==nil then
        return {width=0,height=0} 
    end
    local w,h = obj:getContentSize()
    return {width=w,height=h} 
end

function isEqualPoint(p1,p2)
    if type(p1)=="table" and type(p2)=="table" then
            --todo
        if p1.x==p2.x and p1.y==p2.y then
            --todo
            return true
        end
    end
    
    return false
end    

function printTableInfo(t,name)
    print(name.."=============")

    for k,v in pairs(t) do
        print(k,v)
    end
end    


function printRCTableInfo(t)
    print("RCTable=============")

    for k,v in pairs(t) do
        for k1,v1 in pairs(v) do
            print(k1,v1)
        end
    end
end  

